//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Create IR CMP Request
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define CMP_USER_ID "0002"
#define CMP_SECRET  "qwerty02"
#define CMP_IR_FILE "cmp_ir.bin"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
//------------------------------------------------------------------------------
//    ,    ID  
// :
// 1.   
// 2.       CMP/IR,  
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey,hExpKey;
 DWORD dw,len;
 ALG_ID ai;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,CRYPT_NEWKEYSET,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //   
 if (!CPGenKey(hProv,CALG_EC256_512G_A,CRYPT_EXPORTABLE,&hKey)) {
   printf("CPGenKey CALG_EC256_512G_A Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //     CMP/IR
 if (!CPGenKey(hProv,CALG_CMP_KEY,CRYPT_EXPORTABLE,&hExpKey)) {
   printf("CPGenKey CALG_CMP_KEY Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    IR
 dw=PKI_CMP_IR;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_TYPE,(BYTE*)&dw,0)) {
   printf("CPSetKeyParam KP_CMP_TYPE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 ai=CALG_SHA_160;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_HASH_ALG,(BYTE*)&ai,0)) {
   printf("CPSetKeyParam KP_CMP_HASH_ALG Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //      
 // ai=CALG_SHA_160_HMAC;
 ai=CALG_MAC;
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_MAC_ALG,(BYTE*)&ai,0)) {
   printf("CPSetKeyParam KP_CMP_MAC_ALG Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  ID 
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_SND_KID,(BYTE*)CMP_USER_ID,0)) {
   printf("CPSetKeyParam KP_CMP_SND_KID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPSetKeyParam(hProv,hExpKey,KP_CMP_SECRET,(BYTE*)CMP_SECRET,0)) {
   printf("CPSetKeyParam KP_CMP_SND_KID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=sizeof(WBuf);
 if (!CPExportKey(hProv,hKey,hExpKey,PUBLICKEYBLOB_CMP,0,WBuf,&len)) {
   printf("CPExportKey PUBLICKEYBLOB_CMP Error: %0X\r\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(CMP_IR_FILE,WBuf,len);
 //
 CPDestroyKey(hProv,hKey);
 CPDestroyKey(hProv,hExpKey);
 //
 //   
 if (!CPImportKey(hProv,WBuf,len,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  transactionID  
 len=sizeof(WBuf);
 if (!CPGetKeyParam(hProv,hKey,KP_CMP_TRANS_ID,WBuf,&len,0)) {
   printf("CPGetKeyParam KP_CMP_TRANS_ID Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 WBuf[len]=0;
 printf("transactionID = %s\n",(char*)WBuf);
 CPDestroyKey(hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
